
#include "mb.h"
#include "mbMath.h"
#include "mbConv.h"
#include "time.h"

using namespace std;

static mb g(const mb& x, const mb& n)
{
    mb      z;
    
    z = (x*x + 1) % n;
    if(z.n<0)
        z = z + n;
    return z;
    
}/* g */

int main (int argc, char * const argv[])
{
    mb      n="104039896330367592179398928957";
    mb      x, y, z, d;
    clock_t t;
    
    x = 2;
    y = 2;
    d = 1;
    t = clock();
    while(d==1)
    {
        x = g(x, n);
        z = g(y, n);
        y = g(z, n);
        z = abs(x-y);
        d = gcd(z, n);
    }
    t = clock() - t; // processor time
    
    cout << "d = " << d << endl;
    cout << "time = " << (double)t / CLOCKS_PER_SEC << " sec" << endl;
    return 0;
}
